import { useQuery } from '@tanstack/react-query';
import type { TBaseResponseAPI, TGetListDataKOPDigunggungResult } from '../types/types';
import queryKey from '../constant/queryKey';
import digunggungApi from '../utils/api';

const useGetKodeObjekPajakDigunggung = (params?: Record<string, any>) =>
  useQuery<TBaseResponseAPI<TGetListDataKOPDigunggungResult>>({
    queryKey: queryKey.getKodeObjekPajak(params),
    queryFn: () => digunggungApi.getKodeObjekPajakDigunggung(params),
  });

export default useGetKodeObjekPajakDigunggung;
