import { Divider, Grid } from '@mui/material';
import dayjs from 'dayjs';
import { useFormContext } from 'react-hook-form';
import { Field } from 'src/components/hook-form';
import {
  BUPOT_REFERENSI,
  BUPOT_REFERENSI_TEXT,
  MockNitku,
} from 'src/sections/bupot-21-26/constant';

function DokumenReferensi() {
  const { setValue } = useFormContext();

  const options = Object.entries(BUPOT_REFERENSI).map(([key, value]) => ({
    value,
    label: BUPOT_REFERENSI_TEXT[value],
  }));
  return (
    <Grid container rowSpacing={2} alignItems="center" columnSpacing={2} sx={{ mb: 4 }}>
      <Grid size={{ md: 12 }}>
        <Divider sx={{ fontWeight: 'bold' }} textAlign="left">
          Jenis Dokumen Referensi
        </Divider>
      </Grid>
      <Grid size={{ md: 6 }}>
        <Field.Autocomplete
          name="namaDokumenReferensi"
          label="Jenis Dokumen Referensi"
          options={options}
          onChange={(_, value) => setValue('namaDokumenReferensi', value)}
        />
      </Grid>
      <Grid size={{ md: 6 }}>
        <Field.Text
          name="nomorDokumenReferensi"
          label="Nomor Dokumen Referensi"
        />
      </Grid>
      <Grid size={{ md: 6 }}>
        <Field.DatePicker
          name="tanggalDokumenReferensi"
          label="Tanggal Dokumen Referensi"
          format="DD/MM/YYYY"
          maxDate={dayjs()}
        />
      </Grid>
      <Grid size={{ md: 6 }}>
        <Field.Autocomplete name="idTku" label="NITKU Pemotong" options={MockNitku} />
      </Grid>
    </Grid>
  );
}

export default DokumenReferensi;
