import dayjs from 'dayjs';
import { FG_FASILITAS_DN } from '../constant';

const FASILITAS_LABEL_MAP: Record<string, string> = {
  [FG_FASILITAS_DN.SKB_PPH_PASAL_22]: 'SKB PPh Pasal 22',
  [FG_FASILITAS_DN.SKB_PPH_PASAL_23]: 'SKB PPh Pasal 23',
  [FG_FASILITAS_DN.SKB_PPH_PHTB]: 'SKB PPh PHTB',
  [FG_FASILITAS_DN.DTP]: 'DTP',
  [FG_FASILITAS_DN.SKB_PPH_BUNGA_DEPOSITO_DANA_PENSIUN_TABUNGAN]:
    'SKB PPh Bunga Deposito Dana Pensiun Tabungan',
  [FG_FASILITAS_DN.SUKET_PP23_PP52]: 'Suket PP23/PP52',
  [FG_FASILITAS_DN.SKD_WPLN]: 'SKD WPLN',
  [FG_FASILITAS_DN.FASILITAS_LAINNYA]: 'Fasilitas Lainnya',
  [FG_FASILITAS_DN.TANPA_FASILITAS]: 'Tanpa Fasilitas',
  [FG_FASILITAS_DN.SKB_PPH_PASAL_21]: 'SKB PPh Pasal 21',
  [FG_FASILITAS_DN.DTP_PPH_PASAL_21]: 'DTP PPh Pasal 21',
};

const formatTanggalIndo = (isoDate?: string): string => {
  if (!isoDate) return '';
  return dayjs(isoDate).locale('id').format('DD MMMM YYYY');
};

/**
 * Normalisasi payload Bupot Unifikasi agar sesuai format yang digunakan API cetak PDF
 */
export const normalizePayloadCetakPdf = (payload: Record<string, any>) => {
  if (!payload) return payload;

  const adjusted = { ...payload };

  if (adjusted.tglpemotongan) {
    adjusted.tglPemotongan = formatTanggalIndo(adjusted.tglpemotongan); // versi tampil
  }

  // === Konversi kode fasilitas ke label ===
  const fasilitasCode = adjusted.sertifikatInsentifDipotong;
  adjusted.sertifikatInsentifDipotong = FASILITAS_LABEL_MAP[fasilitasCode] || fasilitasCode || '';

  // === Field default tambahan ===
  adjusted.mixcode = adjusted.mixcode || 'mixcode';
  adjusted.qrcode = adjusted.qrcode || 'qrcode';
  adjusted.metodePembayaranBendahara = adjusted.metodePembayaranBendahara || '-';
  adjusted.nomorSP2D = adjusted.nomorSP2D || '-';
  adjusted.npwpDipotong = adjusted.npwp || '';
  adjusted.namaDipotong = adjusted.nama || '';
  adjusted.nitkuDipotong = adjusted.nik || '';
  adjusted.namaPemotong = adjusted.nama || '';
  adjusted.nitkuPemotong = adjusted.nik || '';
  adjusted.penghasilanBruto = adjusted.dpp || '';
  adjusted.tanggal_Dokumen = adjusted.dokumen_referensi[0].tanggal_Dokumen;
  adjusted.status = 'Proforma';
  adjusted.msPajak = adjusted.masaPajak;
  adjusted.thnPajak = adjusted.tahunPajak;
  adjusted.kdObjPjk = adjusted.kodeObjekPajak;
  adjusted.fgPdf = adjusted.fgPdf === 'TIDAK_TERSEDIA' ? '2' : adjusted.fgPdf;

  return adjusted;
};

export default normalizePayloadCetakPdf;
