export type TBaseResponseAPI<T> = {
  status: string;
  message: string;
  data: T;
  time: string;
  code: number;
  metaPage: TBaseResponseMetaPage;
  total?: number;
};

type TBaseResponseMetaPage = {
  pageNum: number | null;
  rowPerPage: number | null;
  totalRow: number;
};

export type TGetListDataTableSsp = {
  id: number;
  npwpPemotong: string;
  idTku: string;
  msPajak: string;
  thnPajak: string;
  fgNpwpNik: string;
  npwp: string;
  nik: string;
  nama: string;
  sertifikatInsentifDipotong: string;
  noDokLainnya: string;
  kdObjPjk: string;
  pasalPph: string;
  statusPPh: string;
  jmlBruto: string;
  tarif: string;
  pphDipotong: string;
  kap: string;
  kjs: string;
  tglpemotongan: string;
  userId: string;
  created_at: string;
  updated_at: string;
  created_by: string;
  updated_by: string;
  fgStatus: string;
  internal_id: string;
  dokumen_referensi: TDokReferensi[];
  revNo: number;
  noBupot: string;
  idBupot: string;
  npwpNikPenandatangan: string;
  namaPenandatangan: string;
  link: string | null;
  errorMsg: string | null;
  email: string | null;
  glAccount: string;
  fgkirimemail: string;
  fgFasilitas: string;
};

export type TGetListDataTableSspResult = TGetListDataTableSsp[];

export type TGetListDataKOPSsp = {
  kode: string;
  nama: string;
  pasal: string;
  statuspph: string;
  normanetto: string;
  tarif: string;
  kap: string;
  kjs: string;
  noCertificate: number;
  certofDomicile: number;
  otherCert: number;
};

export type TGetListDataKOPSspResult = TGetListDataKOPSsp[];

export type ActionItem = {
  title: string;
  icon: React.ReactNode;
  func?: () => void;
  disabled?: boolean;
};

export type TDokReferensi = {
  namaDok: string;
  nomorDok: string;
  tglDok: string; // format: DDMMYYYY
};

export type TPostSspRequest = {
  id: string | null;
  idBupot: string;
  noBupot: string;
  kanal: string;
  npwpPemotong: string;
  idTku: string;
  masaPajak: string;
  tahunPajak: number;
  sertifikatInsentifDipotong: string;
  nomorSertifikatInsentif: string | null;
  kodeObjekPajak: string;
  pasalPph: string;
  statusPph: string;
  dpp: number;
  tarif: number;
  pphDipotong: number;
  kap: number;
  kjs: number;
  dokReferensi: TDokReferensi[];
  tglPemotongan: string;
  userId: string;
  revNo: number;
  glAccount: string;
};

export type TPostUpload = {
  id: string;
};

export type TDeleteSspRequest = {
  id: string;
};

export type TCancelSspRequest = {
  id: string | number;
  tglPembatalan: string; // format: DDMMYYYY
};

export type TCancelSspResponse = TBaseResponseAPI<{
  id: string | number;
  statusBatal?: string;
  message?: string;
}>;
