import Card from '@mui/material/Card';
import Divider from '@mui/material/Divider';
import Stack from '@mui/material/Stack';
import { CustomBreadcrumbs } from 'src/components/custom-breadcrumbs';
import { DashboardContent } from 'src/layouts/dashboard';
import { AnalyticItem } from './components/AnalyticItem';
import { useTheme } from '@mui/material/styles';
import Typography from '@mui/material/Typography';
import { useSelector } from 'react-redux';
import { RootState } from 'src/store';
import Box from '@mui/material/Box';
import LinearProgress from '@mui/material/LinearProgress';
import Grid from '@mui/material/Grid';
import dayjs from 'dayjs';
import 'dayjs/locale/id';
import VswpChecker from './components/VswpChecker';

export function DashboardView() {
  const theme = useTheme();
  const user = useSelector((state: RootState) => state.user);

  const formatTanggalIndo = (isoDate?: string): string => {
    if (!isoDate) return '';
    return dayjs(isoDate).locale('id').format('DD MMMM YYYY');
  };

  const MasaBerlaku = user.data.end_date ?? '';

  return (
    <>
      <DashboardContent>
        {/* <CustomBreadcrumbs heading="Beranda" /> */}
        <Box sx={{ mt: 3, mb: 3, display: 'flex', gap: '4px' }}>
          <Typography sx={{ fontSize: '24px', fontWeight: 500 }}>Selamat Datang, </Typography>
          <Typography sx={{ fontSize: '24px', fontWeight: 'bold', color: '#143b88' }}>
            {user.data.customer_name}
          </Typography>
        </Box>

        <Card sx={{ mb: { xs: 3, md: 5 } }}>
          <Box>
            <Stack
              divider={<Divider orientation="vertical" flexItem sx={{ borderStyle: 'dashed' }} />}
              sx={{ py: 4, flexDirection: 'row' }}
            >
              <AnalyticItem
                title="e-Bupot Unifikasi"
                total={203}
                percent={100}
                icon="solar:bill-list-bold-duotone"
                color={theme.vars.palette.info.main}
              />
              <AnalyticItem
                title="e-Bupot 21/26"
                total={194}
                percent={100}
                icon="solar:bill-list-bold-duotone"
                color={theme.vars.palette.success.main}
              />
              <AnalyticItem
                title="e-Faktur"
                total={2.221}
                percent={100}
                icon="solar:bill-list-bold-duotone"
                color={theme.vars.palette.error.main}
              />
              <AnalyticItem
                title="Total"
                total={56.118}
                percent={100}
                icon="solar:bill-list-bold-duotone"
                color={theme.vars.palette.warning.main}
              />
            </Stack>
            <Box sx={{ px: 2, mb: 2 }}>
              <LinearProgress
                color="warning"
                variant="determinate"
                value={100}
                sx={{ height: '8px' }}
              />
              <Typography
                sx={{
                  width: '100%',
                  display: 'flex',
                  justifyContent: 'right',
                  mt: 1,
                  fontSize: '12px',
                  fontWeight: 400,
                  color: '#919eab',
                }}
              >
                Total Transaksi Terpakai Periode(07/2024 - 07/2025) : 29728 / 400 (7432%)
              </Typography>
            </Box>
          </Box>
        </Card>
        <Grid container spacing={2}>
          <Grid size={4}>
            <Card sx={{ p: 2, background: '#143b88', position: 'relative', height: '170px' }}>
              <Box sx={{ display: 'flex', alignItems: 'center', justifyContent: 'space-between' }}>
                <Box>
                  <Typography sx={{ fontSize: '24px', color: '#fff', fontWeight: 700 }}>
                    Kuota Transaksi
                  </Typography>
                </Box>
                <Box sx={{ textAlign: 'center' }}>
                  <Typography sx={{ fontSize: '24px', color: '#fff', fontWeight: 700 }}>
                    {user.data.quota}
                  </Typography>
                  <Typography sx={{ fontSize: '16px', color: '#fff', fontWeight: 400 }}>
                    Transaksi
                  </Typography>
                </Box>
              </Box>
              <Typography sx={{ fontSize: '16px', color: '#fff', fontWeight: 700 }}>
                Masa Berlaku Akses Anda
              </Typography>
              <Typography sx={{ fontSize: '22px', color: '#fff', fontWeight: 400 }}>
                {formatTanggalIndo(MasaBerlaku)}
              </Typography>
              <Box
                sx={{
                  width: '17rem',
                  borderRadius: '999px',
                  backgroundColor: '#ffffff',
                  opacity: '0.2',
                  position: 'absolute',
                  right: '-180px',
                  bottom: '-110px',
                  height: '170px',
                }}
              />
              <Box
                sx={{
                  width: '17rem',
                  borderRadius: '999px',
                  backgroundColor: '#ffffff',
                  opacity: '0.2',
                  position: 'absolute',
                  left: '-180px',
                  top: '-110px',
                  height: '170px',
                }}
              />
              <Box
                sx={{
                  width: '17rem',
                  borderRadius: '999px',
                  backgroundColor: '#ffffff',
                  opacity: '0.1',
                  position: 'absolute',
                  left: '-160px',
                  top: '-90px',
                  height: '170px',
                }}
              />
            </Card>
          </Grid>
          <Grid size={4}>
            <Card sx={{ p: 2, background: '#f6f9ff', height: '170px' }}>
              <Box>
                <Typography sx={{ fontSize: '14px', fontWeight: 400, color: '#000' }}>
                  User Email
                </Typography>
                <Typography sx={{ fontSize: '17px', fontWeight: 700, color: '#000' }}>
                  {user.data.email}
                </Typography>
              </Box>
              <Box>
                <Typography sx={{ fontSize: '14px', fontWeight: 400, color: '#000' }}>
                  Company
                </Typography>
                <Typography sx={{ fontSize: '17px', fontWeight: 700, color: '#000' }}>
                  {user.data.company_name}
                </Typography>
              </Box>
              <Box>
                <Typography sx={{ fontSize: '14px', fontWeight: 400, color: '#000' }}>
                  Penandatangan
                </Typography>
                <Typography sx={{ fontSize: '17px', fontWeight: 700, color: '#000' }}>
                  {user.data.signer}
                </Typography>
              </Box>
            </Card>
          </Grid>
          <Grid size={4}>
            <VswpChecker />
          </Grid>
        </Grid>
      </DashboardContent>
    </>
  );
}
