import { useMutation } from '@tanstack/react-query';
import fakturApi from '../utils/api';
import type { TBaseResponseAPI, TIdTambahanResult } from '../types/types';

const useGetIdTambahan = (props?: any) =>
  useMutation<TBaseResponseAPI<TIdTambahanResult>, Error, Record<string, any> | undefined>({
    mutationFn: async (params) => {
      const res = await fakturApi.getIdTambahan(params);
      return res;
    },
    ...props,
  });

export default useGetIdTambahan;
